#include <bits/stdc++.h>

using namespace std;

#define all(a)a.begin(),a.end()
#define sz(a)(int)a.size()
#define int long long

const int inf = 1e18;
const int R = 1 << 18;
const int mod = 1e9 + 7;

struct info {
    int l = 0, r = 0;

    info() {};

    info(int l, int r) : l(l), r(r) {};
};

vector<info> sg(2 * R);

info merge(info a, info b) {
    info c = {a.l, b.r};
    int mn = min(a.r, b.l);
    a.r -= mn;
    b.l -= mn;
    c.l += b.l;
    c.r += a.r;
    return c;
}

info get(int x, int xl, int xr, int ql, int qr) {
    if (xr <= ql || qr <= xl)
        return {0, 0};
    if (ql <= xl && xr <= qr)
        return sg[x];
    int mid = (xl + xr) >> 1;
    return merge(get(x * 2, xl, mid, ql, qr), get(x * 2 + 1, mid, xr, ql, qr));
}

struct mem {
    vector<int> l;
    int r = 0;
    vector<int> sg;

    mem() {};
};

mem merge(mem a, mem b) {
    mem c = mem();
    c.l = a.l;
    c.r = b.r;
    c.sg = {};
    int mn = min(a.r, sz(b.l));
    for (int i = mn; i < sz(b.l); ++i)
        c.l.push_back(b.l[i]);
    a.r -= mn;
    c.r += a.r;
    const int LL = 1 << (__lg(sz(c.l)) + 1);
    c.sg.resize(LL * 2, inf);
    for (int i = 0; i < sz(c.l); ++i)
        c.sg[i + LL] = c.l[i] - 2 * (i + 1);
    for (int i = LL - 1; i > 0; --i)
        c.sg[i] = min(c.sg[i * 2], c.sg[i * 2 + 1]);
    return c;
}

vector<mem> t(2 * R);
int cnt = 0;
int tr = 0;

int gt(int f, int x, int xl, int xr, int ql, int qr) {
    if (qr <= xl || xr <= ql)
        return inf;
    if (ql <= xl && xr <= qr)
        return t[f].sg[x];
    int mid = (xl + xr) >> 1;
    return min(gt(f, x * 2, xl, mid, ql, qr), gt(f, x * 2 + 1, mid, xr, ql, qr));
}

int get_min(int x, int xl, int xr, int ql, int qr, int mx) {

    if (xr <= ql || qr <= xl || mx <= cnt)
        return inf;
    if (ql <= xl && xr <= qr) {
        int res = inf;
        int BEG = min(tr, sz(t[x].l));

        int END = min(sz(t[x].l), mx - cnt + BEG);

        res = min(res, -2 * cnt + gt(x, 1, 0, sz(t[x].sg) / 2, BEG, END));

        tr -= min(tr, sz(t[x].l));
        tr += t[x].r;
        cnt += END - BEG;
        return res;
    }
    int mid = (xl + xr) >> 1;
    return min(get_min(x * 2 + 1, mid, xr, ql, qr, mx), get_min(x * 2, xl, mid, ql, qr, mx));
}

void solve() {
    int n, q;
    string s;
    cin >> n >> q >> s;
    for (int i = 0; i < n; ++i) {
        if (s[i] == '(') {
            sg[i + R].r = 1;
            t[i + R].r++;
        } else {
            sg[i + R].l = 1;
            t[i + R].l.push_back(i);
            t[i + R].sg = {1, i - 2};
        }
    }

    for (int i = R - 1; i > 0; --i) {
        sg[i] = merge(sg[i * 2], sg[i * 2 + 1]);
        t[i] = merge(t[i * 2], t[i * 2 + 1]);
    }
    while (q--) {
        int l, r;
        cin >> l >> r;
        --l;
        int ans = 0;
        info res = get(1, 0, R, l, r);
        if (res.l > res.r)
            swap(res.l, res.r);
        ans += res.r - res.l;
        cnt = 0;
        tr = 0;
        int add = min(get_min(1, 0, R, l, r, res.l) + 1, l);
        ans += 2 * res.l - l + add;
        cout << ans << "\n";
    }
}

signed main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    solve();
    return 0;
}
